Scriptname GenericRaceController extends Quest

; Race Compatibility
FormList Property PlayableRaceList Auto
FormList Property PlayableVampireList Auto

FormList Property RacesHuman Auto
FormList Property RacesBeast Auto
FormList Property RacesElf Auto

; Multi-Race Parts
FormList Property HeadPartsAllRacesMinusBeast  Auto  
FormList Property HeadPartsAllRacesMinusBeastVampires  Auto  

; Human-Race Parts
FormList Property HeadPartsHuman  Auto  
FormList Property HeadPartsHumanVampires  Auto  
FormList Property HeadPartsHumansandVampires  Auto  
FormList Property HeadPartsHumansOrcsandVampires  Auto  
FormList Property HeadPartsHumanoidVampire  Auto  
FormList Property HeadPartsBretsNordsImpsandVampires  Auto  

; Elves Parts
FormList Property HeadPartsElves  Auto  
FormList Property HeadPartsElvesandVampires  Auto  

; Single-Race Parts
FormList Property HeadPartsArgonian  Auto  
FormList Property HeadPartsBreton  Auto  
FormList Property HeadPartsDarkElf  Auto  
FormList Property HeadPartsHighElf  Auto  
FormList Property HeadPartsImperial  Auto  
FormList Property HeadPartsKhajiit  Auto  
FormList Property HeadPartsNord  Auto  
FormList Property HeadPartsOrc  Auto  
FormList Property HeadPartsRedguard  Auto  
FormList Property HeadPartsWoodElf  Auto  

; Single-Race Parts and Vampire
FormList Property HeadPartsArgonianandVampire  Auto  
FormList Property HeadPartsBretonandVampire  Auto  
FormList Property HeadPartsDarkElfandVampire  Auto  
FormList Property HeadPartsHighElfandVampire  Auto  
FormList Property HeadPartsImperialandVampire  Auto  
FormList Property HeadPartsKhajiitandVampire  Auto  
FormList Property HeadPartsNordandVampire  Auto  
FormList Property HeadPartsOrcandVampire  Auto  
FormList Property HeadPartsRedguardandVampire  Auto  
FormList Property HeadPartsWoodElfandVampire  Auto  

; New Races
FormList Property NewArgonian Auto
FormList Property NewBreton Auto
FormList Property NewDarkElf Auto
FormList Property NewHighElf Auto
FormList Property NewImperial Auto
FormList Property NewKhajiit Auto
FormList Property NewNord Auto
FormList Property NewOrc Auto
FormList Property NewRedguard Auto
FormList Property NewWoodElf Auto

; New Races Vampire
FormList Property NewArgonianVampire Auto
FormList Property NewBretonVampire Auto
FormList Property NewDarkElfVampire Auto
FormList Property NewHighElfVampire Auto
FormList Property NewImperialVampire Auto
FormList Property NewKhajiitVampire Auto
FormList Property NewNordVampire Auto
FormList Property NewOrcVampire Auto
FormList Property NewRedguardVampire Auto
FormList Property NewWoodElfVampire Auto


Function AddFormIfNotHas(FormList FL, Form apForm)
	if (apForm != None && !FL.HasForm(apForm))
		FL.AddForm(apForm)
	endif
EndFunction

Form Function GetAtIfValid(FormList FL, int index)
	if (FL != None && index < FL.GetSize())
		return FL.GetAt(index)
	else
		return None
	endif
EndFunction



Function proxyRaces()
	FormList[] RaceList = new FormList[10]
	RaceList[0] = NewArgonian
	RaceList[1] = NewBreton
	RaceList[2] = NewDarkElf
	RaceList[3] = NewHighElf
	RaceList[4] = NewImperial
	RaceList[5] = NewKhajiit
	RaceList[6] = NewNord
	RaceList[7] = NewOrc
	RaceList[8] = NewRedguard
	RaceList[9] = NewWoodElf
	
	FormList[] RaceListVampire = new FormList[10]
	RaceListVampire[0] = NewArgonianVampire
	RaceListVampire[1] = NewBretonVampire
	RaceListVampire[2] = NewDarkElfVampire
	RaceListVampire[3] = NewHighElfVampire
	RaceListVampire[4] = NewImperialVampire
	RaceListVampire[5] = NewKhajiitVampire
	RaceListVampire[6] = NewNordVampire
	RaceListVampire[7] = NewOrcVampire
	RaceListVampire[8] = NewRedguardVampire
	RaceListVampire[9] = NewWoodElfVampire
	
	FormList[] HeadPartsList = new FormList[10]
	HeadPartsList[0] = HeadPartsArgonian
	HeadPartsList[1] = HeadPartsBreton
	HeadPartsList[2] = HeadPartsDarkElf
	HeadPartsList[3] = HeadPartsHighElf
	HeadPartsList[4] = HeadPartsImperial
	HeadPartsList[5] = HeadPartsKhajiit
	HeadPartsList[6] = HeadPartsNord
	HeadPartsList[7] = HeadPartsOrc
	HeadPartsList[8] = HeadPartsRedguard
	HeadPartsList[9] = HeadPartsWoodElf
	
	FormList[] HeadPartsVampireList = new FormList[10]
	HeadPartsVampireList[0] = HeadPartsArgonianandVampire
	HeadPartsVampireList[1] = HeadPartsBretonandVampire
	HeadPartsVampireList[2] = HeadPartsDarkElfandVampire
	HeadPartsVampireList[3] = HeadPartsHighElfandVampire
	HeadPartsVampireList[4] = HeadPartsImperialandVampire
	HeadPartsVampireList[5] = HeadPartsKhajiitandVampire
	HeadPartsVampireList[6] = HeadPartsNordandVampire
	HeadPartsVampireList[7] = HeadPartsOrcandVampire
	HeadPartsVampireList[8] = HeadPartsRedguardandVampire
	HeadPartsVampireList[9] = HeadPartsWoodElfandVampire
	
	int element = 0
	while (element < RaceList.Length)
		FormList RaceFL = RaceList[element]
		FormList RaceVampireFL = RaceListVampire[element]
		
		int index = 0
		Race standardRace = GetAtIfValid(RaceFL, index) as Race
		Race vampireRace  = GetAtIfValid(RaceVampireFL, index) as Race
		while (standardRace != None || vampireRace != None)
			;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			; register as a playable race
			;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			if (standardRace != None && vampireRace != None)
				Quest InitQuest = Game.GetFormFromFile(0x002859, "RaceCompatibility.esm") as Quest ; // 0x002859 = RaceCompatibilityInitQuest
				(InitQuest as YARC_InitQuestScript).RegisterRace(standardRace, vampireRace, element)
			endif
			
			;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			; self listings
			;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			AddFormIfNotHas(HeadPartsList[element], standardRace)
			AddFormIfNotHas(HeadPartsVampireList[element], standardRace)
			AddFormIfNotHas(HeadPartsVampireList[element], vampireRace)
			
			;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			; conditioned listings
			;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			if (isHuman(element) || isOrc(element) || isElf(element))
				AddFormIfNotHas(HeadPartsAllRacesMinusBeast, standardRace)
				AddFormIfNotHas(HeadPartsAllRacesMinusBeast, vampireRace)
				AddFormIfNotHas(HeadPartsAllRacesMinusBeastVampires, standardRace)
				AddFormIfNotHas(HeadPartsHumanoidVampire, vampireRace)
				
				if (isHuman(element))
					AddFormIfNotHas(RacesHuman, standardRace)
					AddFormIfNotHas(HeadPartsHuman, standardRace)
					AddFormIfNotHas(HeadPartsHumanVampires, vampireRace)
					AddFormIfNotHas(HeadPartsHumansandVampires, standardRace)
					AddFormIfNotHas(HeadPartsHumansandVampires, vampireRace)
					AddFormIfNotHas(HeadPartsHumansOrcsandVampires, standardRace)
					AddFormIfNotHas(HeadPartsHumansOrcsandVampires, vampireRace)
					if (isBreton(element) || isNord(element) || isImperial(element))
						AddFormIfNotHas(HeadPartsBretsNordsImpsandVampires, standardRace)
						AddFormIfNotHas(HeadPartsBretsNordsImpsandVampires, vampireRace)
					endif
				elseif (isOrc(element))
					AddFormIfNotHas(HeadPartsHumansOrcsandVampires, standardRace)
					AddFormIfNotHas(HeadPartsHumansOrcsandVampires, vampireRace)
				elseif (isElf(element))
					AddFormIfNotHas(RacesElf, standardRace)
					AddFormIfNotHas(HeadPartsElves, standardRace)
					AddFormIfNotHas(HeadPartsElvesandVampires, standardRace)
					AddFormIfNotHas(HeadPartsElvesandVampires, vampireRace)
				endif
			else
				AddFormIfNotHas(RacesBeast, standardRace)
			endif
			
			index += 1
			standardRace = GetAtIfValid(RaceFL, index) as Race
			vampireRace  = GetAtIfValid(RaceVampireFL, index) as Race
		endwhile
		
		element += 1
	endwhile
EndFunction

Bool Function isHuman(int index)
	if(index == 0)
		return false
	elseif(index == 2)
		return false
	elseif(index == 3)
		return false
	elseif(index == 5)
		return false
	elseif(index == 7)
		return false
	elseif(index == 9)
		return false
	else
		return true
	endif
	return true
EndFunction

Bool Function isBreton(int index)
	if(index == 1)
		return true
	else
		return false
	endif
	return false
EndFunction

Bool Function isNord(int index)
	if(index == 6)
		return true
	else
		return false
	endif
	return false
EndFunction

Bool Function isImperial(int index)
	if(index == 4)
		return true
	else
		return false
	endif
	return false
EndFunction

Bool Function isOrc(int index)
	if(index == 7)
		return true
	else
		return false
	endif
	return false
EndFunction

Bool Function isElf(int index)
	if(index == 2)
		return true
	elseif(index == 3)
		return true
	elseif(index == 9)
		return true
	else
		return false
	endif
	return false
EndFunction
